(function ($) {
  "use strict";
  $("#contacts-table").DataTable({
    processing: true,
    serverSide: true,
    ajax: _url + "/contacts/get_table_data",
    columns: [
      {
        data: "lead_id",
        name: "lead_id",
        orderable: false,
        searchable: false,
        render: function (data, type, row, meta) {
          return (
            '<input type="checkbox" name="lead_id" class="row-checkbox" value="' +
            row.id +
            '">'
          );
        },
      },
      { data: "customer_id", name: "customer_id" },
      { data: "company_name", name: "company_name" },
      /*{ data : "contact_name", name : "contact_name" },*/ /*{ data : "profile_type", name : "profile_type" },*/ /*{ data : "contact_email", name : "contact_email" },*/ {
        data: "contact_phone",
        name: "contact_phone",
      },
      { data: "address", name: "address" },
      {
        data: "converted_by_user_id",
        name: "converted_by_user_id",
        render: function (data, type, row, meta) {
          return row.assignuser && row.assignuser.name
            ? row.assignuser.name
            : "N/A";
        },
      },

      {
        data: "assign_id",
        name: "assign_id",
        render: function (data, type, row, meta) {
          return row.assignusername && row.assignusername.name
            ? row.assignusername.name
            : "N/A";
        },
      },
      { data: "contact_name", name: "contact_name" },
      /*	{ data : "group.name", name : "group.name" },				{ data : "amount", name : "amount" },					{ data : "subscription_type", name : "subscription_type" },*/ 
      {
        data: "action",
        name: "action",
      },
    ],
    responsive: true,
    bStateSave: true,
    bAutoWidth: false,
    ordering: false,
    language: {
      decimal: "",
      emptyTable: $lang_no_data_found,
      info:
        $lang_showing +
        " _START_ " +
        $lang_to +
        " _END_ " +
        $lang_of +
        " _TOTAL_ " +
        $lang_entries,
      infoEmpty: $lang_showing_0_to_0_of_0_entries,
      infoFiltered: "(filtered from _MAX_ total entries)",
      infoPostFix: "",
      thousands: ",",
      lengthMenu: $lang_show + " _MENU_ " + $lang_entries,
      loadingRecords: $lang_loading,
      processing: $lang_processing,
      search: $lang_search,
      zeroRecords: $lang_no_matching_records_found,
      paginate: {
        first: $lang_first,
        last: $lang_last,
        next: $lang_next,
        previous: $lang_previous,
      },
    },
  });
})(jQuery);

$.ajaxSetup({
  headers: {
    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
  },
});

$(document).on("change", ".row-checkbox", function () {
  let anyChecked = $(".row-checkbox:checked").length > 0;

  if (anyChecked) {
    $("#lead-assign-btn").removeClass("disabled").removeAttr("disabled");
  } else {
    $("#lead-assign-btn").addClass("disabled").attr("disabled", true);
  }
});

$("#select-all").on("click", function () {
  var checked = this.checked;
  $(".row-checkbox").each(function () {
    this.checked = checked;
  });

  if (checked) {
    $("#lead-assign-btn").removeClass("disabled").removeAttr("disabled");
  } else {
    $("#lead-assign-btn").addClass("disabled").attr("disabled", true);
  }
});



// submit assign form start 
$(document).on("submit", "#assign_lead_id", function (e) {
  e.preventDefault();
  let user_id = $("#user_id").val();
  if (user_id == "") {
    $.toast({
      text: "Please Select User",

      showHideTransition: "slide",

      icon: "error",

      position: "top-right",
    });
    return false;
  }

  // Get all checked lead_id values
  let lead_ids = [];
  $(".row-checkbox:checked").each(function () {
    lead_ids.push($(this).val());
  });

  // If none checked, alert and stop submission
  if (lead_ids.length === 0) {
    $.toast({
      text: "Please select at least one lead",

      showHideTransition: "slide",

      icon: "error",

      position: "top-right",
    });
    return false;
  }

  $.ajax({
    method: "POST",
    url: $(this).attr("action"),
    data: {
      leadIds: lead_ids,
      userId: user_id,
      _token: $('meta[name="csrf-token"]').attr("content"), // Add CSRF token manually
    },
    beforeSend: function () {
      $("#preloader").fadeIn();
    },
    success: function (data) {
      $("#preloader").fadeOut();

      if (data["result"] == true) {
        // toast_alert( "success", data['message'] );

        $.toast({
          text: data["message"],

          showHideTransition: "slide",

          icon: "success",

          position: "top-right",
        });

        // ✅ Hide the modal
        $("#exampleModal").modal("hide");

        // ✅ Reset the user select field
        $("#user_id").val("");

        // ✅ Uncheck all checkboxes
        $("#select-all").prop("checked", false);
        $(".row-checkbox").prop("checked", false);

        // ✅ Optionally, reset form fields
        $("#assign_lead_id")[0].reset();
        $("#lead-assign-btn").addClass("disabled").attr("disabled", true);
        
      }
    },
    error: function (request, status, error) {
      console.log(request.responseText);
    },
  });
  return false;
});
// submit assign form end 
